#!/usr/bin/perl
#
#           RiLax 0.1.03
#
# plain text database search engine, 
# version 0.1
# (c) Sergej Tarasov, 2001
#
# Homepage: http://risearch.org/
# email: risearch@risearch.org
# Last modified: 06.04.2001

#======================================================
# Konfiguration

# Verzeichnis der Log Dateien
# Erstellen Sie das Verzeichnis von Hand und vegeben Sie CHMOD 777
$log_dir = "log";

# Farbe der Zellen und des Tabellenrandes
$bordercolor = "#000000";
$cellcolor   = "#FFFFFF";

# Pfad zu der Grafik welche als Statistikchartbalken verwendet wird

$path_to_image = "../../bar.gif";

# Fertig !!!
#======================================================

print "Content-Type: text/html\n\n";

opendir(dir,"$log_dir");
@files=grep { /\d\d\d\d\.\d\d\.\d\d/ } readdir(dir);
@files=sort {$b cmp $a} @files;


$count = 0;

for $list(0..6) {
    if ($list > scalar(@files)-1) { last }
    $filename=$log_dir."/".$files[$list];
    open FILE, $filename;
    foreach $query (<FILE>) {
    	chomp($query);
    	if ($query eq "") {next}
    	$count += 1;
    	$queries{$query} += 1;
    	$count_7 += 1;
    	$queries_7{$query} += 1;
    }
    close(FILE);
};


for $list(7..29) {
    if ($list > scalar(@files)-1) { last }
    $filename=$log_dir."/".$files[$list];
    open FILE, $filename;
    foreach $query (<FILE>) {
    	chomp($query);
    	if ($query eq "") {next}
    	$count += 1;
    	$queries{$query} += 1;
    }
    close(FILE);
};




open HEADER, $log_dir."/statheader";
print <HEADER>;
close(HEADER);

print "<H3>Suchbegriff Statistik</H3>\n";
print "Anzahl der Abfragen:\n";
print "<BR>Letzte  30 Tage - $count\n";
print "<BR>Letzte   7 Tage - $count_7\n";
print "<BR><BR>\n";
print "Top 20 der Suchbegriffe:<BR><BR>\n";
print "<TABLE WIDTH=90% ALIGN=center BORDER=0 CELLPADDING=0 CELLSPACING=0>\n";
print "<TR><TD BGCOLOR=$bordercolor>";
print "<TABLE WIDTH=100% ALIGN=center BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
print "<TR><TD ALIGN=right BGCOLOR=$cellcolor><B>Suchbegriffe:&nbsp;&nbsp;</B></TD><TD ALIGN=center COLSPAN=3 BGCOLOR=$cellcolor>Letzte 30 Tage</TD><TD ALIGN=center COLSPAN=3 BGCOLOR=$cellcolor>Letzte 7 Tage</TD></TR>\n";
@k = sort {$queries{$b} <=> $queries{$a}} keys %queries;
for $i (0..19) {
    if ($i > scalar(@k)-1) { last }
    $first += $queries{$k[$i]};
    $first_7 += $queries_7{$k[$i]};
    $proc = sprintf ("%.2f", $queries{$k[$i]} / $count * 100);
    $proc_7 = sprintf ("%.2f", $queries_7{$k[$i]} / $count_7 * 100);
    $len = int ($queries{$k[$i]} / $queries{$k[$0]} * 100);
    $len_7 = int ($queries_7{$k[$i]} / $queries{$k[$0]} * 100);
    if ($len == 0) {$len = 1}
    if ($len_7 == 0) {$len_7 = 1}
    print "<TR>\n";
    print "<TD ALIGN=right WIDTH=40% BGCOLOR=$cellcolor>$k[$i]&nbsp;&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$queries{$k[$i]}&nbsp;&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$proc&nbsp;%</TD>\n";
    print "<TD ALIGN=left WIDTH=120 BGCOLOR=$cellcolor>&nbsp;&nbsp;&nbsp;<IMG SRC=$path_to_image ALIGN=absmiddle ALT=\"\" WIDTH=$len HEIGHT=6 BORDER=0></TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$queries_7{$k[$i]}&nbsp;&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$proc_7&nbsp;%</TD>\n";
    print "<TD ALIGN=left WIDTH=120 BGCOLOR=$cellcolor>&nbsp;&nbsp;&nbsp;<IMG SRC=$path_to_image ALIGN=absmiddle ALT=\"\" WIDTH=$len_7 HEIGHT=6 BORDER=0></TD>\n";
    print "</TR>\n";
}
$other = $count - $first;
$proc = sprintf ("%.2f", $other / $count * 100);
$other_7 = $count_7 - $first_7;
$proc_7 = sprintf ("%.2f", $other_7 / $count_7 * 100);

    print "<TR>\n";
    print "<TD ALIGN=right WIDTH=40% BGCOLOR=$cellcolor><B>Andere</B>&nbsp;&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$other&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$proc&nbsp;%</TD>\n";
    print "<TD ALIGN=left WIDTH=120 BGCOLOR=$cellcolor>&nbsp;&nbsp;&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$other_7&nbsp;</TD>\n";
    print "<TD ALIGN=right WIDTH=5% BGCOLOR=$cellcolor>$proc_7&nbsp;%</TD>\n";
    print "<TD ALIGN=left WIDTH=120 BGCOLOR=$cellcolor>&nbsp;&nbsp;&nbsp;</TD>\n";
    print "</TR>\n";


print "</TD></TR>";
print "</TABLE>\n";
print "</TABLE>\n";
open FOOTER, $log_dir."/statfooter";
print <FOOTER>;
close(FOOTER);


